/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.disc;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.impl.disc.DiscoveryPlugin;
import com.ibm.hwmca.fw.fcs.impl.disc.PollableDiscoveryPlugin;
import com.ibm.hwmca.fw.fcs.impl.stream.FcsControlClient;
import com.ibm.hwmca.fw.fcs.impl.udp.NotificationQueue;
import com.ibm.hwmca.fw.util.HMCTimer;
import com.ibm.hwmca.fw.util.HMCTimerTask;
import com.ibm.hwmca.fw.util.TimerParms;
import com.ibm.hwmca.fw.util.TimerTaskExecutionControl;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DiscoveryCenter {
    private static final String TRACE_MASKD = "XFCSDISD";
    private static final String TRACE_MASKF = "XFCSDISF";
    private static final String TRACE_MASKT = "XFCSDIST";
    private Map discoveryPlugins = new HashMap();
    private static DiscoveryCenter _singleton;
    private static Object singletonLock;
    public static final DiscoveryPlugin fcsInternallyDiscovered;
    private static HMCTimer hmcTimer;
    private static NotificationQueue newInetAddressQueue;
    private static DiscoveryCenterWorker worker;

    private DiscoveryCenter() {
        this.discoveryPlugins.put(fcsInternallyDiscovered, new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DiscoveryCenter getDiscoveryCenter() {
        Object object = singletonLock;
        synchronized (object) {
            if (_singleton == null) {
                _singleton = new DiscoveryCenter();
                _singleton.init();
                worker = new DiscoveryCenterWorker();
                worker.start();
            }
        }
        return _singleton;
    }

    private void init() {
        Set pluginClasses = FcsServer.getFcsServer().getConfigManager().getDiscoveryPlugins();
        Iterator iterator = pluginClasses.iterator();
        while (iterator.hasNext()) {
            String className = (String)iterator.next();
            try {
                Class<?> cl = Class.forName(className);
                DiscoveryPlugin plugin = (DiscoveryPlugin)cl.newInstance();
                Trace.trace(TRACE_MASKF, "Instantiated plugin: " + className);
                this.discoveryPlugins.put(plugin, new HashSet());
                if (!(plugin instanceof Runnable)) continue;
                Thread pluginThread = new Thread((Runnable)((Object)plugin), "FCS Discovery Plugin - " + className);
                pluginThread.start();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Error using '" + className + "' as a FCS discovery plugin: " + e.getMessage());
            }
        }
        TimerParms parms = new TimerParms(FcsServer.getFcsServer().getConfigManager().getMachineSearchTime() * 1000, (long)(FcsServer.getFcsServer().getConfigManager().getMachineSearchTime() * 1000), true);
        hmcTimer.schedule((HMCTimerTask)new PollingTask(), parms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void poll() {
        DiscoveryPlugin plugin;
        Iterator<Object> iterator;
        HashSet<DiscoveryPlugin> plugins = new HashSet<DiscoveryPlugin>();
        Object object = singletonLock;
        synchronized (object) {
            iterator = this.discoveryPlugins.keySet().iterator();
            while (iterator.hasNext()) {
                plugin = (DiscoveryPlugin)iterator.next();
                if (!(plugin instanceof PollableDiscoveryPlugin)) continue;
                plugins.add(plugin);
            }
        }
        Set unclaimedAddys = (Set)this.discoveryPlugins.get(fcsInternallyDiscovered);
        iterator = plugins.iterator();
        while (iterator.hasNext()) {
            plugin = (PollableDiscoveryPlugin)iterator.next();
            HashSet addys = (HashSet)this.discoveryPlugins.get(plugin);
            if (addys == null) {
                addys = new HashSet();
                this.discoveryPlugins.put(plugin, addys);
            }
            InetAddress[] addresses = null;
            try {
                addresses = plugin.getAvailableAddresses();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Error polling plugin: " + plugin);
                Trace.trace(TRACE_MASKF, e);
            }
            if (addresses == null) continue;
            addys.clear();
            this.foundAddresses(addresses, plugin);
        }
    }

    public void foundAddress(InetAddress address, DiscoveryPlugin plugin) {
        this.foundAddresses(new InetAddress[]{address}, plugin);
    }

    public void foundAddresses(InetAddress[] addresses, DiscoveryPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin may not be null");
        }
        if (addresses == null) {
            throw new IllegalArgumentException("Addresses may not be null");
        }
        Set addys = (Set)this.discoveryPlugins.get(plugin);
        Set unclaimedAddys = (Set)this.discoveryPlugins.get(fcsInternallyDiscovered);
        for (int i = 0; i < addresses.length; ++i) {
            if (addresses[i] == null) continue;
            if (FcsServer.getFcsServer().getMachineId(addresses[i]) == null) {
                newInetAddressQueue.addItem(addresses[i]);
                Trace.trace(TRACE_MASKF, "Adding [" + addresses[i] + "] on behalf of " + plugin);
            }
            if (addys != null) {
                addys.add(addresses[i]);
            }
            unclaimedAddys.remove(addresses[i]);
        }
    }

    public void removeAddress(InetAddress address, DiscoveryPlugin plugin) {
        this.removeAddresses(new InetAddress[]{address}, plugin);
    }

    public void removeAddresses(InetAddress[] addresses, DiscoveryPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin may not be null");
        }
        if (addresses == null) {
            throw new IllegalArgumentException("Addresses may not be null");
        }
        Set addys = (Set)this.discoveryPlugins.get(plugin);
        for (int i = 0; i < addresses.length; ++i) {
            if (addresses[i] == null || addys == null) continue;
            Trace.trace(TRACE_MASKF, "Removing [" + addresses[i] + "] on behalf of " + plugin);
            addys.remove(addresses[i]);
            FcsControlClient fcc = new FcsControlClient(addresses[i], "FcsControlCommandDataExchange");
            Thread t = new Thread((Runnable)fcc, "FCS verification exchange to " + addresses[i]);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getKnownAddressesByPlugin(String pluginClassName) {
        try {
            DiscoveryPlugin pluginObject = null;
            Class<?> cl = Class.forName(pluginClassName);
            Object object = singletonLock;
            synchronized (object) {
                Iterator iterator = this.discoveryPlugins.keySet().iterator();
                while (iterator.hasNext()) {
                    DiscoveryPlugin plugin = (DiscoveryPlugin)iterator.next();
                    if (!plugin.getClass().getName().equals(pluginClassName)) continue;
                    pluginObject = plugin;
                }
            }
            if (pluginObject != null) {
                return this.getKnownAddressesByPlugin(pluginObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Set getKnownAddressesByPlugin(DiscoveryPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin may not be null");
        }
        Set addys = (Set)this.discoveryPlugins.get(plugin);
        Set returnAddys = (Set)((HashSet)addys).clone();
        return returnAddys;
    }

    public void registerPlugin(DiscoveryPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin may not be null");
        }
        this.discoveryPlugins.put(plugin, new HashSet());
    }

    public void unregisterPlugin(DiscoveryPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin may not be null");
        }
        this.discoveryPlugins.remove(plugin);
    }

    static {
        singletonLock = new Object();
        fcsInternallyDiscovered = new DiscoveryPlugin(){};
        hmcTimer = HMCTimer.getHMCTimer();
        newInetAddressQueue = new NotificationQueue();
    }

    static class DiscoveryCenterWorker
    extends Thread {
        DiscoveryCenterWorker() {
            try {
                this.setName("Discovery Center Worker");
            }
            catch (Exception e) {
                Trace.trace(DiscoveryCenter.TRACE_MASKF, "error setting discovery center worker name");
            }
        }

        public void run() {
            while (true) {
                InetAddress iaddr = (InetAddress)newInetAddressQueue.readItem();
                try {
                    Trace.trace(DiscoveryCenter.TRACE_MASKF, "worker read item: " + iaddr);
                    if (FcsServer.getFcsServer().getMachineId(iaddr) == null) {
                        Trace.trace(DiscoveryCenter.TRACE_MASKF, "Worker did not find MachineID for the IP");
                        FcsControlClient fcc = new FcsControlClient(iaddr, "FcsControlCommandDataExchange");
                        fcc.run();
                        continue;
                    }
                    Trace.trace(DiscoveryCenter.TRACE_MASKF, "Worker already knew about that IP");
                    continue;
                }
                catch (Exception e) {
                    Trace.trace(DiscoveryCenter.TRACE_MASKF, "error communicating with " + iaddr);
                    continue;
                }
                break;
            }
        }
    }

    static class PollingTask
    implements HMCTimerTask {
        PollingTask() {
        }

        public void run(TimerTaskExecutionControl timerTaskExecutionControl, Object runParms) {
            Trace.trace(DiscoveryCenter.TRACE_MASKF, " PollingTask pops, calling poll().");
            DiscoveryCenter.getDiscoveryCenter().poll();
        }
    }
}

